/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.recipestages.RecipeStages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ActionSetPackageStages
implements IUndoableAction {
    private final String packageName;
    private final String[] stages;

    public ActionSetPackageStages(String packageName, String[] stages) {
        this.packageName = packageName;
        this.stages = stages;
    }

    public void undo() {
        Set strings = RecipeStages.PACKAGE_STAGES.computeIfAbsent(this.packageName, s -> new HashSet());
        strings.removeAll(Arrays.asList(this.stages));
    }

    public String describeUndo() {
        return "Removing the stages \"" + Arrays.toString(this.stages) + "\" of package: \"" + this.packageName + "\"";
    }

    public void apply() {
        Set strings = RecipeStages.PACKAGE_STAGES.computeIfAbsent(this.packageName, s -> new HashSet());
        strings.addAll(Arrays.asList(this.stages));
    }

    public String describe() {
        return "Set the stages of package: \"" + this.packageName + "\" to: " + Arrays.toString(this.stages);
    }
}

